// hack - evalovanie onclick attributov pri vsetkych prvkoch s classou "help"
var help_links_exec = function(){
	$$('.help').each(function(el){
		if(el.getProperty('clickable') != '1'){
			el.addEvent('click', function(){
				help(this.getProperty('section'));
			});
			el.setProperty('clickable', '1');
		}
	});
}

window.addEvent('domready', function(){
	help_links_exec.periodical(1000);
});

// singleton function calling one instance of help
var __HelpMain = null;
var help = function(offset){
	if (__HelpMain === null) {
  	__HelpMain = new HelpMain();
		CLIMCore.addEvent('closing', __HelpMain.close.bind(__HelpMain));
  }
	__HelpMain.show(offset);
}

var HelpMain = new Class({
  Implements: [Options, Events],
	options: {
		width: 421, 
		height: 442
	},
	owner: null,
	window: null,
	native_window: null,
	
	initialize: function(options){
    this.setOptions(options);
		
		var title = "CLIM - Pomocník";
		
		// create new window
		this.window = window.open("help.html", title, "height=" + this.options.height + ", width=" + this.options.width);
		this.native_window = this.window.nativeWindow;
		
		this.window.document.title = title;
		this.window.opener = this;
		
		// assign onClose event
		this.native_window.addEventListener(air.Event.CLOSE, this.onClose.bind(this));
		this.native_window.addEventListener(air.Event.CLOSING, this.onBeforeClose.bind(this));
		this.native_window.addEventListener("resizing", function(event){
			event.stop();
			event.preventDefault();
		});
	},
	
	show: function(offset){
		if(__HelpMain == null) return;
		if (!$defined(this.window.document) || !$defined(this.window.document.body)) {
			return this.show.delay(100, this, offset);
		}	else {
			this.open();
			var el = this.window.document.body.getElementById(offset);
			var pos = el.getPosition();
			
			var m = this.window.document.body.getElementById('_main');
			m.scrollTo(0, m.getScroll().y + pos.y - 20);
		}
	},
	
	open: function(){
	  this.native_window.activate(); 
	},
	
	close: function(){
		if (!$defined(this.native_window) || this.native_window.closed) return;
		this.native_window.close();
	},
	
	onClose: function(){
		this.window = null;
		this.native_window = null;
		__HelpMain = null;
	},	
	
	onLoad: function(){},
	onBeforeClose: function(){},	
	reload: function(){}
});